
<form class="form-addSingle" method="post" action="<?php echo e(route('release.track.edit.modal',$release->id)); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="track_id" value="<?php echo e($track->id); ?>" />
    <div class="modal-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="artistSingle">Artist</label>

                    <select name="artists" id="artists" class="form-control" required>
                        <option value="">Select Artist</option>
                        <?php $__currentLoopData = $artists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $artist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($artist->id); ?>"
                            <?php if($artist->id==$track->artists): ?> selected <?php endif; ?>><?php echo e(ucfirst($artist->name)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="displayArtist">Display Artist</label>
                    <input type="text" class="form-control" name="display_artist" id="display-artist" value="<?php echo e($track->display_artist ?? ''); ?>" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="featuredArtist">Featured Artist</label>
                    <input type="text" class="form-control" name="feature_artist" placeholder="Featured Artist" id="feature_artist" value="<?php echo e($track->feature_artist ?? ''); ?>" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="artistTitle">Title</label>
                    <input type="text" class="form-control" name="title" id="Release-Title" required value="<?php echo e($track->title ?? ''); ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="mainGenre">Main Genre</label>
                    <select name="genre_id" id="genre_id" class="form-control" required>
                        <option value="">Select Genre</option>
                        <?php $__currentLoopData = $genres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($genre->id); ?>" <?php if($track->genre_id==$genre->id): ?> selected <?php endif; ?> ><?php echo e(ucfirst($genre->title)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                </div>
            </div>


            <div class="col-md-6" id="tracksubgenredata">
                <div class="form-group single-artist">
                    <label class="form-label" for="subGenre">Sub Genre</label>
                    <select name="subgenre_id" id="subgenre_id" class="form-control">
                        <option value="">Select Sub Genre</option>

                        <?php
                        $subgenres = App\Models\SubGenre::where('genre_id',$track->genre_id)->get();
                        ?>

                        <?php $__currentLoopData = $subgenres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subgenre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($subgenre->id); ?>" <?php if($track->subgenre_id == $subgenre->id): ?> selected <?php endif; ?>><?php echo e($subgenre->title); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </select>
                </div>
            </div>


            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="disk">Disk</label>
                    <input class="form-control" name="disc" type="text" id="disk" value="<?php echo e($track->disc); ?>" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="track">Track#</label>
                    <input class="form-control" name="serial_number" type="text" id="serial_number" value="<?php echo e($track->serial_number); ?>" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="arranger">Arranger</label>
                    <input class="form-control" type="text" id="arranger" value="<?php echo e($track->arranger); ?>" name="arranger" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="actor">Actor</label>
                    <input class="form-control" type="text" id="actor" value="<?php echo e($track->actor); ?>" name="actor">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="coductor">Conductor</label>
                    <input class="form-control" type="text" id="conductor" value="<?php echo e($track->conductor); ?>" name="conductor" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="composer">Composer</label>
                    <input class="form-control" type="text" id="composer" value="<?php echo e($track->composer); ?>" name="composer" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="mixVersion">Mix Version</label>
                    <input class="form-control" type="text" id="mix_version" name="mix_version" value="<?php echo e($track->mix_version); ?>" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="chooseRemixer">Choose Remixer</label>
                    <select name="remixer" id="remixer" class="form-control">
                        <option value="">Select Remixer</option>
                        <?php $__currentLoopData = getTrackRemixers(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remixer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php if($track->remixer == $remixer): ?> selected <?php endif; ?> value="<?php echo e($remixer); ?>">
                            <?php echo e($remixer); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="orEnter">Or Enter Remixer(s)</label>
                    <input class="form-control" type="text" id="remixer_list" name="remixer_list[]" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="orchestra">Orchestra</label>
                    <input class="form-control" type="text" id="orchestra" value="<?php echo e($track->orchestra); ?>" name="orchestra" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="publisher">Publisher</label>
                    <input class="form-control" type="text" id="publisher" name="publisher" value="<?php echo e($track->publisher); ?>" />
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="contributors">Contributors</label>
                    <input class="form-control" type="text" id="contributors" name="contributors" value="<?php echo e($track->contributors); ?>" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="priceTires">Price Tires (For iTunes Only)</label>

                    <select name="price_tier" id="price_tier" class="form-control">
                        <option value="">Select Price Tier</option>
                        <?php $__currentLoopData = release_prices_tires(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price_key => $price_val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($price_key); ?>" <?php if($track->price == $price_key): ?> selected <?php endif; ?>>
                            <?php echo e($price_val); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="priceTires">Audio File (Must be Wav - 44.1khz)</label>
                    <input class="form-control custom-file-input" type="file" id="my_audio_files" accept=".wav" name="my_audio_files" />
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group single-artist">
                    <label class="form-label" for="priceTires">Do you have ISRC?</label>
                    <div class="main-form-radio d-flex justify-content-start gap-3">

                        <div class="radio-btn">
                            <input type="radio" class="form-check-input me-1" name="have_isrc" id="yes"  value="1" <?php if($track->have_isrc == 1): ?> checked <?php endif; ?> />
                            <label class="form-check-label" for="yes">Yes</label>
                        </div>

                        <div class="radio-btn">
                            <input type="radio" class="form-check-input me-1" name="have_isrc" id="no" value="0" <?php if($track->have_isrc == 0): ?> checked <?php endif; ?> />
                            <label class="form-check-label" for="no">No</label>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-check-main">
                    <div class="form-check single-artist-check">
                        <input class="form-check-input" type="checkbox" id="explicit" name="explicit" value="1" 
                        <?php if($track->explicit == 1): ?> checked <?php endif; ?> />
                        <label class="form-check-label" for="orEnter">Explicit</label>
                    </div>
                    <div class="form-check single-artist-check">
                        <input class="form-check-input" type="checkbox" id="sold_with_album" name="sold_with_album" value="1" <?php if($track->sold_with_album == 1): ?> checked <?php endif; ?> />
                        <label class="form-check-label" for="orEnter">Yes, this track can be sold with full album</label>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
    <div class="modal-footer">
        <button type="submit" class="btn add-single-btn">Update</button>
    </div>
</form>


<?php /**PATH C:\xampp\htdocs\UploadDSP_LARAVEL\resources\views/releases/edit-track.blade.php ENDPATH**/ ?>